//
//  MCBrowserController.h
//  MCApplication
//
//  Created by Alykhan Jetha on Tue Jan 29 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>

@class BDQualifier;

@interface MCBrowserController : NSObject {
	IBOutlet	NSBrowser		*browser;
	
	id			delegate;
	
	id			_model;
	NSArray*    _arrangedObjects;
	
	NSString	*_displayAttributeName;
	NSString	*_childrenAttributeName;

	NSArray*       _sortDescriptors;
	BDQualifier*   _filterQualifier;
	BDQualifier*   _childFilterQualifier;
	
	int mode;  // 0 = legacy (default)/1 = new (uses sort and filtering)
}


- (void)rearrangeObjects;
- (NSArray *)arrangedObjects;

- (void)useNewMode;
- (void)useLegacyMode;

// DOES NOT WORK WITH MULTISELECTION ENABLED ON THE BROWSER!!!!!!
// Will return an array of objects, which are in order from column 0
- (NSArray*)selectedObjects;

/*
Warning -- does not handle key paths yet ...
*/

- (NSBrowser *)browser;
- (void)setBrowser:(NSBrowser *)aBrowser;

- (id)delegate;
- (void)setDelegate:(id)aDeleg;

- (void)setModel:(id)aModel;
- (void)setModelNoUpdate:aModel;
- (id)model;
- (void)updateInterfaceFromModel;


- (NSString *)displayAttributeName;
- (void)setDisplayAttributeName:(NSString *)aName;

- (NSString *)childrenAttributeName;
- (void)setChildrenAttributeName:(NSString *)aName;

- (NSArray *)sortDescriptors;
- (void)setSortDescriptors:(NSArray *)aSortDescriptors;

- (BDQualifier *)filterQualifier;
- (void)setFilterQualifier:(BDQualifier *)aFilterQualifier;

- (BDQualifier*)childFilterQualifier;
- (void)setChildFilterQualifier: (BDQualifier*)aQualifier;

@end


@interface NSObject (BrowserControllerDelegate)

-(void)browserController:(MCBrowserController *)bc didSelectObject:(id)obj;

- (void)browserController:(MCBrowserController *)bc didDoubleClickObject:(id)obj;
@end
